unit fOther;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ORCtrls, ExtCtrls, ORNet, ORFn;

type
  TfrmOther = class(TForm)
    lblProc: TLabel;
    lblCPT: TLabel;
    pnl1: TPanel;
    btnEdit: TButton;
    btnDel: TButton;
    lbOther: TORListBox;
    btnExit: TBitBtn;
    btnEnter: TBitBtn;
    pnlProc: TPanel;
    cbOther: TORComboBox;
    btnAdd: TButton;
    lblSel: TLabel;
    lblSel3: TLabel;
    lblLat: TLabel;
    cbOLat: TORComboBox;
    lblLat2: TLabel;
    pnlOR: TPanel;
    lblSel2: TLabel;
    edOProc: TEdit;
    lblSel1: TLabel;
    cbOCPT: TORComboBox;
    lblLoc: TLabel;
    edOLoc: TEdit;
    lblLoc1: TLabel;
    btnAct: TButton;
    procedure lbOtherClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure HideSelection;
    procedure ShowSelection;
    procedure btnEditClick(Sender: TObject);
    procedure btnDelClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnEnterClick(Sender: TObject);
    procedure cbOtherClick(Sender: TObject);
    procedure edOProcClick(Sender: TObject);
    procedure cbOCPTClick(Sender: TObject);
    procedure cbOLatClick(Sender: TObject);
    procedure cbOCPTChange(Sender: TObject);
    procedure cbOtherChange(Sender: TObject);
    procedure btnActClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    frmOther: TfrmOther;
  end;

var
  frmOther: TfrmOther;
  Edit, OtherChange: integer;
  ProcIFN, OCPTIFN, LatIFN: string;

procedure GetOther(TempList: TListBox; LType: string);

implementation

{$R *.dfm}

uses fRequest, SCMMain, fWait, rLocal;

procedure GetOther(TempList: TListBox; LType: string);
var
  J: integer;
begin
  frmOther := TfrmOther.Create(Application);
  try
  with frmOther do
    begin
      if List = 'R' then
        begin
          Left := frmRequest.Left + 50;
          Top  := frmRequest.Top + 170;
        end;
      if (List = 'A') or (List = 'W') then
        begin
          Left := frmWait.Left + 50;
          Top  := frmWait.Top + 170;
        end;
      lbOther.Clear;
      if TempList.Items.Count > 0 then
        begin
          for J := 0 to TempList.Items.Count-1 do lbOther.Items.Add(TempList.Items[J]);
        end;
      if (UsePTLD = 1) then
        begin
          CallV('APTWL GET PROC', []);
          cbOther.Items := RPCBrokerV.Results;
        end;
      CallV('APTWL GET CPT', []);
      cbOCPT.Items     := RPCBrokerV.Results;
      CallV('APTWL GET LATERALITY', []);
      cbOLat.Items      := RPCBrokerV.Results;
      HideSelection;
      btnEdit.Enabled  := False;
      btnDel.Enabled   := False;
      btnEnter.Enabled := False;
      if UsePTLD = 0 then
        begin
          lblSel.Enabled  := False;
          cbOther.Enabled := False;
          lblSel3.Enabled := False;
        end;
      Edit := 0;
      OtherChange := 0;
      ShowModal;
    end;
  finally
    frmOther.Release;
  end;
end;

procedure TfrmOther.lbOtherClick(Sender: TObject);
begin
  ResetTimeOut;
  btnEdit.Enabled := True;
  btnDel.Enabled  := True;
end;

procedure TfrmOther.btnAddClick(Sender: TObject);
begin
  ShowSelection;
  btnEnter.Caption := 'Place on List';
end;

procedure TfrmOther.HideSelection;
begin
  pnlProc.Visible  := False;
  btnEnter.Visible := False;
end;

procedure TfrmOther.ShowSelection;
begin
  pnlProc.Visible  := True;
  btnEnter.Visible := True;
  if UsePTLD = 0 then
    begin
      lblSel.Enabled  := False;
      cbOther.Enabled := False;
    end;
end;

procedure TfrmOther.btnEditClick(Sender: TObject);
var
  Node, Key: string;
begin
  node := lbOther.Items[lbOther.ItemIndex];
  Key  := piece(node, '^', 7);
  if Key = '1' then
    begin
      ProcIFN      := piece(Node, '^', 2);
      cbOther.Text := piece(Node, '^', 3);
    end
  else edOProc.Text := piece(Node, '^', 4);
  OCPTIFN     := piece(Node, '^', 5);
  cbOCPT.Text := piece(Node, '^', 6);
  cbOLat.Text := piece(Node, '^', 8);
  edOLoc.Text := piece(Node, '^', 9);
  ShowSelection;
  Edit := 1;
  btnEnter.Caption := 'Save Changes';
end;

procedure TfrmOther.btnDelClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to delete the entry?', mtconfirmation, [mbYes, mbNo], 0) = mrNo then
    begin
      Exit;
    end;
  lbOther.Items.Delete(lbOther.ItemIndex);
  OtherChange := 1;
end;

procedure TfrmOther.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmOther.btnEnterClick(Sender: TObject);
var
  X, Data, Proc: string;
  Key: integer;
  // if using Portland procedures, KEY = 1
begin
  if cbOther.Text <> '' then Key := 1
    else Key := 0;
  if Key = 1 then Proc := cbOther.Text
    else Proc := edOProc.Text;
  if Edit = 1 then
    begin
      X := lbOther.Items[lbOther.ItemIndex];
      SetPiece(X, '^', 1, Proc);
      SetPiece(X, '^', 2, ProcIFN);
      SetPiece(X, '^', 3, cbOther.Text);
      SetPiece(X, '^', 4, edOProc.Text);
      SetPiece(X, '^', 5, OCPTIFN);
      SetPiece(X, '^', 6, cbOCPT.Text);
      SetPiece(X, '^', 7, IntToStr(Key));
      SetPiece(X, '^', 8, cbOLat.Text);
      SetPiece(X, '^', 9, edOLoc.Text);
      lbOther.Items[lbOther.ItemIndex] := X;
      OtherChange := 1;
    end;
  if Edit = 0 then
    begin
      if (cbOther.Text = '') and (edOProc.Text = '') then Exit;
      //if cbOther.Text <> '' then ProcIFN := IntToStr(cbOther.ItemIEN);
      Data := Proc + '^' + ProcIFN + '^' + cbOther.Text + '^' + edOProc.Text;
      if cbOCPT.Text <> '' then Data := Data + '^' + OCPTIFN + '^' + cbOCPT.Text;
      SetPiece(Data, '^', 7, IntToStr(Key));
      SetPiece(Data, '^', 8, cbOLat.Text);
      SetPiece(Data, '^', 9, edOLoc.Text);
      lbOther.Items.Add(Data);
      OtherChange := 1;
    end;
  Edit := 0;
  HideSelection;
  cbOther.Text  := '';
  cbOCPT.Text   := '';
  edOProc.Text  := '';
  cbOLat.Text    := '';
  edOLoc.Text    := '';
end;

procedure TfrmOther.cbOtherClick(Sender: TObject);
begin
  ProcIFN := IntToStr(cbOther.ItemIEN);
  btnEnter.Enabled := True;
end;

procedure TfrmOther.edOProcClick(Sender: TObject);
begin
  btnEnter.Enabled := True;
end;

procedure TfrmOther.cbOCPTClick(Sender: TObject);
begin
  OCPTIFN := IntToStr(cbOCPT.ItemIEN);
  btnEnter.Enabled := True;
end;

procedure TfrmOther.cbOLatClick(Sender: TObject);
begin
  btnEnter.Enabled := True;
end;

procedure TfrmOther.cbOCPTChange(Sender: TObject);
begin
  if cbOCPT.Text = '' then Exit;
  CallV('APTWL GET CPT', [cbOCPT.Text]);
  cbOCPT.Items := RPCBrokerV.Results;
  cbOCPT.DroppedDown := True;
end;

procedure TfrmOther.cbOtherChange(Sender: TObject);
begin
  if cbOther.Text = '' then Exit;
  CallV('APTWL GET PROC', [cbOther.Text]);
  cbOther.Items := RPCBrokerV.Results;
  cbOther.DroppedDown := True;
end;

procedure TfrmOther.btnActClick(Sender: TObject);
begin
  HideSelection;
  if Edit = 1 then btnEdit.Enabled := False;
end;

end.
